;;  Programm:      ACM-SKALBEZ.LSP
;;  Befehlsaufruf: ACM-SKALBEZ
;;  Funktion:      Vergrert oder verkleinert Objekte oder deren Kopie proportional
;;                 anhand einer Bezugslnge und einer angegebenen Lnge.
;;  Autor:         Gerhard Rampf
;;                 Kundenspezifische Anpassungen fr AutoCAD und ZWCAD
;;                 Liebigstr. 3 A
;;                 86399 Bobingen
;;                 E-Mail: rampf@geracad.de
;;  Datum:         18.06.2023
;;  Plattform:     Alle AutoCAD-Versionen ab Version 2005
(defun c:acm-skalbez ( / skb43 skb00 skb47 skb48 skb49 skb50 bks01 bks02 bks04 bks05 bks06 bks07 bks08 bks09 bks10 bks11 bks12 bks13 bks14 bks15 bks16 bks17)
    (defun bks01 (skb01 / skb09 skb10 skb11 skb12 skb13)
        (if (not (vl-position (type acmx20231skalbezglobalevariable) (list 'INT 'REAL)))
          (setq acmx20231skalbezglobalevariable 1.0)
        )
        (if (not (vl-position (type acmx20232skalbezglobalevariable) (list 'INT 'REAL)))
          (setq acmx20232skalbezglobalevariable 1.0)
        )
      (setq skb09 (getvar "OSMODE"))
      (setq skb10 (getvar "ORTHOMODE"))
      (setq skb11 "")
        (while (= (type skb11) 'STR)
            (if (= skb11 "Einstellungen")
              (bks14)
            )
            (if (= acmx20237skalbezglobalevariable 0) 
              (setvar "OSMODE" skb09)
              (setvar "OSMODE" acmx20236skalbezglobalevariable)
            )
          (initget 8 "Einstellungen")
          (setq skb11 (getpoint "\nBasispunkt angeben oder [Einstellungen]: "))
          (setvar "OSMODE" skb09)
        )
        (if skb11
          (progn
              (if (= acmx20237skalbezglobalevariable 0) 
                (setvar "OSMODE" skb09)
                (setvar "OSMODE" acmx20236skalbezglobalevariable)
              )
              (if (= acmx20238skalbezglobalevariable 0) 
                (setvar "ORTHOMODE" skb10)
                (setvar "ORTHOMODE" acmx20239skalbezglobalevariable)
              )
            (initget 6 "Objekt Einstellungen")
            (setq skb12 (getdist (strcat "\nBezugslnge angeben oder [Objekt/Einstellungen] <" (bks16 acmx20231skalbezglobalevariable) ">: ")))
            (setvar "OSMODE" skb09)
            (setvar "ORTHOMODE" skb10)
              (if (not skb12)
                (setq skb12 acmx20231skalbezglobalevariable)
              )
              (while (= (type skb12) 'STR)
                  (if (= skb12 "Einstellungen")
                    (bks14)
                      (if (not (setq skb12 (bks02 skb01)))
                        (setq skb12 "")
                      )
                  )
                  (if (not (vl-position (type skb12) (list 'INT 'REAL)))
                    (progn
                        (if (= acmx20237skalbezglobalevariable 0) 
                          (setvar "OSMODE" skb09)
                          (setvar "OSMODE" acmx20236skalbezglobalevariable)
                        )
                        (if (= acmx20238skalbezglobalevariable 0) 
                          (setvar "ORTHOMODE" skb10)
                          (setvar "ORTHOMODE" acmx20239skalbezglobalevariable)
                        )
                      (initget 6 "Objekt Einstellungen")
                      (setq skb12 (getdist (strcat "\nBezugslnge angeben oder [Objekt/Einstellungen] <" (bks16 acmx20231skalbezglobalevariable) ">: ")))
                      (setvar "OSMODE" skb09)
                      (setvar "ORTHOMODE" skb10)
                    )
                  )
                  (if (not skb12)
                    (setq skb12 acmx20231skalbezglobalevariable)
                  )
              )
              (if skb12
                (progn
                    (if (= acmx20237skalbezglobalevariable 0) 
                      (setvar "OSMODE" skb09)
                      (setvar "OSMODE" acmx20236skalbezglobalevariable)
                    )
                    (if (= acmx20238skalbezglobalevariable 0) 
                      (setvar "ORTHOMODE" skb10)
                      (setvar "ORTHOMODE" acmx20239skalbezglobalevariable)
                    )
                  (initget 6 "Objekt Einstellungen")
                  (setq skb13 (getdist (strcat "\nNeue Lnge angeben oder [Objekt/Einstellungen] <" (bks16 acmx20232skalbezglobalevariable) ">: ")))
                  (setvar "OSMODE" skb09)
                  (setvar "ORTHOMODE" skb10)
                    (if (not skb13)
                      (setq skb13 acmx20232skalbezglobalevariable)
                    )
                    (while (= (type skb13) 'STR)
                        (if (= skb13 "Einstellungen")
                          (bks14)
                            (if (not (setq skb13 (bks02 skb01)))
                              (setq skb13 "")
                            )
                        )
                        (if (not (vl-position (type skb13) (list 'INT 'REAL)))
                          (progn
                              (if (= acmx20237skalbezglobalevariable 0) 
                                (setvar "OSMODE" skb09)
                                (setvar "OSMODE" acmx20236skalbezglobalevariable)
                              )
                              (if (= acmx20238skalbezglobalevariable 0) 
                                (setvar "ORTHOMODE" skb10)
                                (setvar "ORTHOMODE" acmx20239skalbezglobalevariable)
                              )
                            (initget 6 "Objekt Einstellungen")
                            (setq skb13 (getdist (strcat "\nNeue Lnge angeben oder [Objekt/Einstellungen] <" (bks16 acmx20232skalbezglobalevariable) ">: ")))
                            (setvar "OSMODE" skb09)
                            (setvar "ORTHOMODE" skb10)
                          )
                        )
                        (if (not skb13)
                          (setq skb13 acmx20232skalbezglobalevariable)
                        )
                    )
                )
              )
          )
        )
        (if
          (and
            skb11
            skb12
            skb13
          )
            (list
              skb11
              (setq acmx20231skalbezglobalevariable skb12)
              (setq acmx20232skalbezglobalevariable skb13)
            )
            nil
        )
    )
    (defun bks02 (skb01 / skb14 skb15 skb16 skb17 skb18 bks03)
      (defun bks03 (skb01 / ) (if (= acmx20233skalbezglobalevariable 1) (setvar "PICKBOX" acmx20234skalbezglobalevariable)))
      (setq skb14 T)
      (setq skb15 (nth acmx20235skalbezglobalevariable (list entsel nentsel)))
      (bks05 skb01)
        (if (ssget "_i")
          (sssetfirst nil nil)
        )
      (setq skb16 (getvar "ERRNO"))
        (while skb14
          (setvar "ERRNO" 7)
            (while (equal (getvar "ERRNO") 7)
              (setvar "ERRNO" 0)
              (bks03 skb01)
              (initget "Einstellungen")
              (setq skb17 (skb15 "\nObjekt mit Lngendefinition whlen oder [Einstellungen]: "))
              (setvar "PICKBOX" skb01)
                (while (= (type skb17) 'STR)
                  (bks06 skb01)
                  (setq skb15 (nth acmx20235skalbezglobalevariable (list entsel nentsel)))
                  (bks03 skb01)
                  (initget "Einstellungen")
                  (setq skb17 (skb15 "\nObjekt mit Lngendefinition whlen oder [Einstellungen]: "))
                  (setvar "PICKBOX" skb01)
                )
                (if (= (getvar "ERRNO") 7)
                  (princ "0 gefunden")
                )
            )
            (if skb17
              (progn
                (if (not (setq skb18 (bks04 (car skb17))))
                  (progn
                    (princ "\nUngltig. Gewhltes Objekt besitzt keine Lngendefinition.")
                    (setq skb14 T)
                  )
                  (setq skb14 nil)
                )
              )
              (setq skb14 nil)
            )
        )
        (if skb16
          (setvar "ERRNO" skb16)
        )
      skb18
    )
    (defun bks04 (skb02 / skb19)
      (vl-load-com)
        (if
          (and
            (setq skb19 (vla-get-ObjectName (vlax-ename->vla-object skb02)))
            (vl-position (strcase skb19) '("ACDB2DPOLYLINE" "ACDB3DPOLYLINE" "ACDBARC" "ACDBCIRCLE" "ACDBELLIPSE" "ACDBHELIX" "ACDBLINE" "ACDBPOLYLINE" "ACDBSPLINE"))
          )
            (vlax-curve-getDistAtParam skb02 (vlax-curve-getEndParam skb02))
            nil
        )
    )
    (defun bks05 (skb01 / skb20 skb21)
        (if (= acmx20233skalbezglobalevariable 0)
          (setq skb20 (strcat "\nAkt. Einst. fr Quellobjektwahl: Pickbox-Gre = Aktuell (" (itoa skb01) "),"))
          (setq skb20 (strcat "\nAkt. Einst. fr Quellobjektwahl: Pickbox-Gre = Befehlsabhngig (" (itoa acmx20234skalbezglobalevariable) "),"))
        )
      (setq skb21 (strcat "Blockelemente whlbar = " (nth acmx20235skalbezglobalevariable (list "Nein" "Ja")) " "))
      (prompt (strcat skb20 skb21))
    )
    (defun bks06 (skb01 / skb25 skb26 skb27 skb28)
        (if (not (vl-position acmx20233skalbezglobalevariable (list 0 1)))
          (setq acmx20233skalbezglobalevariable 0)
        )
        (if (not (vl-position acmx20234skalbezglobalevariable (list 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20)))
          (progn
            (setq acmx20233skalbezglobalevariable 0)
            (setq acmx20234skalbezglobalevariable (getvar "PICKBOX"))
          )
        )
        (if (not (vl-position acmx20235skalbezglobalevariable (list 0 1)))
          (setq acmx20235skalbezglobalevariable 0)
        )
        (if (setq skb25 (bks07))
          (progn
            (setq skb26 (load_dialog skb25))
              (if (not (new_dialog "acm_sbe" skb26))
                (exit)
              )
            (vl-catch-all-apply 'vl-file-delete (list skb25))
            (start_list "pl_01")
            (mapcar 'add_list (list (strcat "Akt. (" (itoa (getvar "PICKBOX")) ")") "1" "2" "3" "4" "5" "6" "7" "8" "9" "10" "11" "12" "13" "14" "15" "16" "17" "18" "19" "20"))
            (end_list)
            (set_tile "tg_01" (itoa acmx20235skalbezglobalevariable))
              (if (= acmx20233skalbezglobalevariable 0)
                (set_tile "pl_01" "0")
                (set_tile "pl_01" (itoa acmx20234skalbezglobalevariable))
              )
              (action_tile "b_01" "(setq skb27 (atoi (get_tile \"pl_01\")))
                  (if (= skb27 0)
                    (progn
                      (setq acmx20233skalbezglobalevariable 0)
                      (setq acmx20234skalbezglobalevariable (getvar \"PICKBOX\"))
                    )
                    (progn
                      (setq acmx20233skalbezglobalevariable 1)
                      (setq acmx20234skalbezglobalevariable skb27)
                    )
                  )
                (setq skb28 (list (setq acmx20235skalbezglobalevariable (atoi (get_tile \"tg_01\"))) acmx20233skalbezglobalevariable acmx20234skalbezglobalevariable))
                (done_dialog)
                (bks05 skb01)"
              )
            (action_tile "b_02" "(setq skb28 nil) (done_dialog)")
            (start_dialog)
            (unload_dialog skb26)
          )
        )
      skb28
    )
    (defun bks07 ( / skb31 skb29 skb30)
      (if
        (and
          (setq skb29 (vl-filename-mktemp "acm.dcl"))
          (setq skb30 (open skb29 "w"))
        )
          (progn
            (setq skb31
              (list
                "acm_sbe"
                ":dialog{label=\042Einstellungen\042;"
                ":spacer{height=0.2;}"
                ":popup_list{key=\042pl_01\042;label=\042&Pickbox-Gre:\042;edit_width=8;}"
                ":spacer{height=0.6;}"
                ":toggle{key=\042tg_01\042;label=\042&Blockelemente whlbar\042;}"
                ":spacer{height=0.3;}"
                ":row{"
                ":spacer{width=0;}"
                ":column{width=0;fixed_width=true;"
                ":button{key=\042b_01\042;label=\042OK\042;is_default=true;}"
                ":button{key=\042b_02\042;label=\042Abbrechen\042;is_cancel=true;}}"
                ":spacer{width=0;}}}"
              )
            )
              (while skb31
                (write-line (car skb31) skb30)
                (setq skb31 (cdr skb31))
              )
            (setq skb30 (close skb30))
            skb29
          )
          nil
      )
    )
    (defun bks08 (skb03 / )
        (if skb48 (setq *error* skb48))
        (if skb46
          (vl-catch-all-apply 'setvar (list "PICKBOX" skb46))
        )
        (if skb43
          (vl-catch-all-apply 'setvar (list "CMDECHO" skb43))
        )
        (if skb09
          (vl-catch-all-apply 'setvar (list "OSMODE" skb09))
        )
        (if skb10
          (vl-catch-all-apply 'setvar (list "ORTHOMODE" skb10))
        )
        (if skb00
          (vl-catch-all-apply 'setvar (list "AUTOSNAP" skb00))
        )
      (vla-EndUndoMark (vla-get-ActiveDocument (vlax-get-acad-object)))
      (princ)
    )
    (defun bks09 ( / skb32)
      (setq skb32 (strcase (getvar "PRODUCT")))
        (if
          (and
            (= skb32 "AUTOCAD")
            (getvar "HPDRAWORDER")
          )
            (setq skb33 T)
            (setq skb33 nil)
        )
        (if (not skb33)
          (alert "\042acm-skalbez\042 kann nur unter AutoCAD ab Version 2005 verwendet werden.")
        )
      skb33
    )
    (defun bks10 ( / skb29 skb30 skb31)
      (if
        (and
          (setq skb29 (vl-filename-mktemp "acm.dcl"))
          (setq skb30 (open skb29 "w"))
        )
          (progn
            (setq skb31
              (list
                "omodi"
                ":dialog{label=\042Einstellungen\042;"
                ":spacer{height=0.3;}"
                ":boxed_column{label=\042Objektfangmodi\042;"
                ":radio_button{key=\042ofmaktuelle\042;label=\042Aktuelle &verwenden\042;}"
                ":row{"
                ":radio_button{key=\042ofmbefabh\042;label=\042&Befehlsabh. verw.\042;}"
                ":button{key=\042...\042;label=\042...\042;}}}"
                ":boxed_column{label=\042Orthomodus\042;"
                ":radio_button{key=\042omoaktuelle\042;label=\042A&ktuellen verwenden\042;}"
                ":radio_button{key=\042omobefabh\042;label=\042Be&fehlsabh. verw.\042;}"
                ":row{"
                ":spacer{width=0;}"
                ":toggle{key=\042orthoein\042;label=\042&Ortho ein\042;}"
                ":spacer{width=9;}}}"
                ":spacer{height=0;}"
                ":toggle{key=\042kopie\042;label=\042Kopie &skalieren\042;}"
                ":spacer{height=0.6;}"
                ":row{"
                ":spacer{width=4;}"
                ":column{width=0;fixed_width=true;"
                ":button{key=\042ok\042;label=\042OK\042;is_default=true;}"
                ":button{key=\042abbrechen\042;label=\042Abbrechen\042;is_cancel=true;}}"
                ":spacer{width=4;}}}"
              )
            )
              (while skb31
                (write-line (car skb31) skb30)
                (setq skb31 (cdr skb31))
              )
            (setq skb30 (close skb30))
            skb29
          )
          nil
      )
    )
    (defun bks11 ( / skb29 skb30 skb31)
      (if
        (and
          (setq skb29 (vl-filename-mktemp "acm.dcl"))
          (setq skb30 (open skb29 "w"))
        )
          (progn
            (setq skb31
              (list
                "rotbez"
                ":dialog{label=\042Befehlsabh. Objektfangmodi\042;"
                ":spacer{height=0.5;}"
                ":row{"
                ":spacer{width=0;}"
                ":column{"
                ":toggle{key=\042endpunkt\042;label=\042&Endpunkt\042;}"
                ":toggle{key=\042mittelpunkt\042;label=\042&Mittelpunkt\042;}"
                ":toggle{key=\042zentrum\042;label=\042&Zentrum\042;}"
                ":toggle{key=\042geomzentrum\042;label=\042Ge&om. Zentr.\042;}"
                ":toggle{key=\042punkt\042;label=\042P&unkt\042;}"
                ":toggle{key=\042quadrant\042;label=\042&Quadrant\042;}"
                ":toggle{key=\042schnittpunkt\042;label=\042&Schnittpunkt\042;}}"
                ":column{"
                ":toggle{key=\042hilfslinie\042;label=\042H&ilfslinie\042;}"
                ":toggle{key=\042basispunkt\042;label=\042&Basispunkt\042;}"
                ":toggle{key=\042lot\042;label=\042&Lot\042;}"
                ":toggle{key=\042tangente\042;label=\042Ta&ngente\042;}"
                ":toggle{key=\042naechsterpunkt\042;label=\042N&chster Punkt\042;}"
                ":toggle{key=\042angenschnittp\042;label=\042&Angen. Schnittp.\042;}"
                ":toggle{key=\042parallel\042;label=\042&Parallel\042;}}}"
                ":spacer{height=0.6;}"
                ":row{"
                ":spacer{width=4;}"
                ":column{width=0;fixed_width=true;"
                ":button{key=\042ok\042;label=\042OK\042;is_default=true;}"
                ":button{key=\042abbrechen\042;label=\042Abbrechen\042;is_cancel=true;}}"
                ":spacer{width=4;}}}"
              )
            )
              (while skb31
                (write-line (car skb31) skb30)
                (setq skb31 (cdr skb31))
              )
            (setq skb30 (close skb30))
            skb29
          )
          nil
      )
    )
    (defun bks12 ( / skb25 skb26 skb09 skb33)
        (if (setq skb25 (bks11))
          (progn
            (setq skb26 (load_dialog skb25))
              (if (not (new_dialog "rotbez" skb26))
                (exit)
              )
            (vl-catch-all-apply 'vl-file-delete (list skb25))
            (setq skb09 (getvar "OSMODE"))
              (if (= (type (vl-catch-all-apply 'setvar (list "OSMODE" acmx20236skalbezglobalevariable))) 'VL-CATCH-ALL-APPLY-ERROR)
                (setq acmx20236skalbezglobalevariable 0)
              )
            (setvar "OSMODE" skb09)
            (setq skb35 acmx20236skalbezglobalevariable)
              (if (= (logand acmx20236skalbezglobalevariable 1) 1)
                (set_tile "endpunkt" "1")
              )
              (if (= (logand acmx20236skalbezglobalevariable 2) 2)
                (set_tile "mittelpunkt" "1")
              )
              (if (= (logand acmx20236skalbezglobalevariable 4) 4)
                (set_tile "zentrum" "1")
              )
              (if (= (logand acmx20236skalbezglobalevariable 8) 8)
                (set_tile "punkt" "1")
              )
              (if (= (logand acmx20236skalbezglobalevariable 16) 16)
                (set_tile "quadrant" "1")
              )
              (if (= (logand acmx20236skalbezglobalevariable 32) 32)
                (set_tile "schnittpunkt" "1")
              )
              (if (= (logand acmx20236skalbezglobalevariable 64) 64)
                (set_tile "basispunkt" "1")
              )
              (if (= (logand acmx20236skalbezglobalevariable 128) 128)
                (set_tile "lot" "1")
              )
              (if (= (logand acmx20236skalbezglobalevariable 256) 256)
                (set_tile "tangente" "1")
              )
              (if (= (logand acmx20236skalbezglobalevariable 512) 512)
                (set_tile "naechsterpunkt" "1")
              )
              (if (= (logand acmx20236skalbezglobalevariable 1024) 1024)
                (set_tile "geomzentrum" "1")
              )
              (if (= (logand acmx20236skalbezglobalevariable 2048) 2048)
                (set_tile "angenschnittp" "1")
              )
              (if (= (logand acmx20236skalbezglobalevariable 4096) 4096)
                (set_tile "hilfslinie" "1")
              )
              (if (= (logand acmx20236skalbezglobalevariable 8192) 8192)
                (set_tile "parallel" "1")
              )
            (action_tile "ok" "(setq skb33 (setq acmx20236skalbezglobalevariable (bks13))) (done_dialog)")
            (action_tile "abbrechen" "(setq skb33 skb35) (done_dialog)")
            (start_dialog)
            (unload_dialog skb26)
          )
        )
      skb33
    )
    (defun bks13 ( / )
      (setq acmx20236skalbezglobalevariable 0)
        (if (= (get_tile "endpunkt") "1")
          (setq acmx20236skalbezglobalevariable (+ acmx20236skalbezglobalevariable 1))
        )
        (if (= (get_tile "mittelpunkt") "1")
          (setq acmx20236skalbezglobalevariable (+ acmx20236skalbezglobalevariable 2))
        )
        (if (= (get_tile "zentrum") "1")
          (setq acmx20236skalbezglobalevariable (+ acmx20236skalbezglobalevariable 4))
        )
        (if (= (get_tile "punkt") "1")
          (setq acmx20236skalbezglobalevariable (+ acmx20236skalbezglobalevariable 8))
        )
        (if (= (get_tile "quadrant") "1")
          (setq acmx20236skalbezglobalevariable (+ acmx20236skalbezglobalevariable 16))
        )
        (if (= (get_tile "schnittpunkt") "1")
          (setq acmx20236skalbezglobalevariable (+ acmx20236skalbezglobalevariable 32))
        )
        (if (= (get_tile "basispunkt") "1")
          (setq acmx20236skalbezglobalevariable (+ acmx20236skalbezglobalevariable 64))
        )
        (if (= (get_tile "lot") "1")
          (setq acmx20236skalbezglobalevariable (+ acmx20236skalbezglobalevariable 128))
        )
        (if (= (get_tile "tangente") "1")
          (setq acmx20236skalbezglobalevariable (+ acmx20236skalbezglobalevariable 256))
        )
        (if (= (get_tile "naechsterpunkt") "1")
          (setq acmx20236skalbezglobalevariable (+ acmx20236skalbezglobalevariable 512))
        )
        (if (= (get_tile "geomzentrum") "1")
          (setq acmx20236skalbezglobalevariable (+ acmx20236skalbezglobalevariable 1024))
        )
        (if (= (get_tile "angenschnittp") "1")
          (setq acmx20236skalbezglobalevariable (+ acmx20236skalbezglobalevariable 2048))
        )
        (if (= (get_tile "hilfslinie") "1")
          (setq acmx20236skalbezglobalevariable (+ acmx20236skalbezglobalevariable 4096))
        )
        (if (= (get_tile "parallel") "1")
          (setq acmx20236skalbezglobalevariable (+ acmx20236skalbezglobalevariable 8192))
        )
      acmx20236skalbezglobalevariable
    )
    (defun bks14 ( / skb25 skb26 skb36 skb33)
        (if (setq skb25 (bks10))
          (progn
            (setq skb26 (load_dialog skb25))
              (if (not (new_dialog "omodi" skb26))
                (exit)
              )
            (vl-catch-all-apply 'vl-file-delete (list skb25))
            (setq skb36 acmx20236skalbezglobalevariable)
              (if (= acmx20237skalbezglobalevariable 0)
                (progn
                  (set_tile "ofmaktuelle" "1")
                  (mode_tile "..." 1)
                )
                (set_tile "ofmbefabh" "1")
              )
              (if (= acmx20238skalbezglobalevariable 0)
                (progn
                  (set_tile "omoaktuelle" "1")
                  (mode_tile "orthoein" 1)
                )
                (set_tile "omobefabh" "1")
              )
            (set_tile "orthoein" (itoa acmx20239skalbezglobalevariable))
              (if (= acmx20230skalbezglobalevariable 1)
                (set_tile "kopie" "1")
              )
            (action_tile "ofmaktuelle" "(set_tile \"ofmbefabh\" \"0\") (mode_tile \"...\" 1)")
            (action_tile "ofmbefabh" "(set_tile \"ofmaktuelle\" \"0\") (mode_tile \"...\" 0) (mode_tile \"...\" 2)")
            (action_tile "omoaktuelle" "(set_tile \"omobefabh\" \"0\") (mode_tile \"orthoein\" 1)")
            (action_tile "omobefabh" "(set_tile \"omoaktuelle\" \"0\") (mode_tile \"orthoein\" 0)")
            (action_tile "..." "(setq acmx20236skalbezglobalevariable (bks12))")
              (action_tile "ok" "(setq skb33
                  (list
                    (setq acmx20237skalbezglobalevariable (atoi (get_tile \"ofmbefabh\")))
                    (setq acmx20238skalbezglobalevariable (atoi (get_tile \"omobefabh\")))
                    (setq acmx20239skalbezglobalevariable (atoi (get_tile \"orthoein\")))
                    (setq acmx20230skalbezglobalevariable (atoi (get_tile \"kopie\")))
                  )
                )
               (done_dialog)
               (bks15)"
              )
            (action_tile "abbrechen" "(setq acmx20236skalbezglobalevariable skb36) (setq skb33 nil) (done_dialog)")
            (start_dialog)
            (unload_dialog skb26)
          )
        )
      skb33
    )
    (defun bks15 ( / skb09)
      (setq skb09 (getvar "OSMODE"))
        (if (not (vl-position acmx20233skalbezglobalevariable (list 0 1)))
          (setq acmx20233skalbezglobalevariable 0)
        )
        (if (not (vl-position acmx20234skalbezglobalevariable (list 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20)))
          (progn
            (setq acmx20233skalbezglobalevariable 0)
            (setq acmx20234skalbezglobalevariable (getvar "PICKBOX"))
          )
        )
        (if (not (vl-position acmx20235skalbezglobalevariable (list 0 1)))
          (setq acmx20235skalbezglobalevariable 0)
        )
        (if (= (type (vl-catch-all-apply 'setvar (list "OSMODE" acmx20236skalbezglobalevariable))) 'VL-CATCH-ALL-APPLY-ERROR)
          (setq acmx20236skalbezglobalevariable 0)
        )
      (setvar "OSMODE" skb09)
        (if (not (vl-position acmx20237skalbezglobalevariable (list 0 1)))
          (setq acmx20237skalbezglobalevariable 0)
        )
        (if (not (vl-position acmx20238skalbezglobalevariable (list 0 1)))
          (setq acmx20238skalbezglobalevariable 0)
        )
        (if (not (vl-position acmx20239skalbezglobalevariable (list 0 1)))
          (setq acmx20239skalbezglobalevariable 0)
        )
        (if (not (vl-position acmx20230skalbezglobalevariable (list 0 1)))
          (setq acmx20230skalbezglobalevariable 0)
        )
        (prompt
          (strcat
            "\nAktuelle Einstellungen: OFANG = "
            (nth acmx20237skalbezglobalevariable (list "Aktuell" "Befehlsabh."))
            ", ORTHO = "
              (if (= acmx20238skalbezglobalevariable 0)
                (strcat "Aktuell (" (nth (getvar "ORTHOMODE") (list "Aus" "Ein")) ")")
                (nth acmx20239skalbezglobalevariable (list "Aus" "Ein"))
              )
            ", Kopie skalieren = "
            (nth acmx20230skalbezglobalevariable (list "Nein" "Ja"))
          )
        )
    )
    (defun bks16 (skb04 / skb41 skb42 skb33)
      (setq skb41 (getvar "LUPREC"))
      (setq skb42 (getvar "DIMZIN"))
      (setvar "DIMZIN" 8)
      (setvar "LUPREC" 8)
      (setq skb33 (rtos skb04))
      (setvar "DIMZIN" skb42)
      (setvar "LUPREC" skb41)
      skb33
    )
    (defun bks17 (skb05 skb06 / skb43 skb09)
      (setq skb43 (getvar "CMDECHO"))
      (setq skb09 (getvar "OSMODE"))
      (setvar "CMDECHO" 0)
      (setvar "OSMODE" 0)
        (if (= acmx20230skalbezglobalevariable 1)
          (vl-cmdf "._copy" skb05 "" (list 0.0 0.0 0.0) (list 0.0 0.0 0.0))
        )
      (vl-cmdf "._scale" skb05 "" (car skb06) "_r" (setq skb44 (cadr skb06)) (setq skb45 (caddr skb06)))
      (setvar "CMDECHO" skb43)
      (setvar "OSMODE" skb09)
        (prompt
          (strcat
            "\nBezugslnge = "
            (bks16 skb44)
            ", neue Lnge = "
            (bks16 skb45)
            ", Skalierfaktor = "
            (rtos (/ skb45 skb44) 2 8)
          )
        )
    )
  (if (bks09)
    (progn
      (vl-load-com)
      (setq skb43 (getvar "CMDECHO"))
      (setq skb00 (getvar "AUTOSNAP"))
      (setvar "CMDECHO" 0)
      (setq skb46 (getvar "PICKBOX"))
      (setq skb47 (vla-get-ActiveDocument (vlax-get-acad-object)))
      (setq skb48 *error*)
      (setq *error* bks08)
      (vla-EndUndoMark skb47)
      (vla-StartUndoMark skb47)
      (prompt "\nMit ACM-SKALBEZ zu skalierende Objekte whlen ... ")
        (if (setq skb49 (ssget "_:L"))
          (progn
            (bks15)
              (if (setq skb50 (bks01 skb46))
                (bks17 skb49 skb50)
              )
          )
          (prompt "\nKeine Objekte gewhlt. ")
        )
        (if skb48
          (setq *error* skb48)
          (setq *error* nil)
        )
      (setvar "PICKBOX" skb46)
      (setvar "AUTOSNAP" skb00)
      (setvar "CMDECHO" skb43)
      (vla-EndUndoMark skb47)
    )
  )
  (princ)
)
(terpri)
(princ "\nAutoLISP-Tool ACM-SKALBEZ (Copyright  2023 Gerhard Rampf) geladen.")
(princ "\nRufen Sie den Befehl mit ACM-SKALBEZ auf.")
